package gov.va.genisis2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import org.apache.log4j.Logger;

/**
 * 
 * @author PII
 *
 */
public class PropertyManager {

	private static final Logger LOGGER = Logger.getLogger(PropertyManager.class);

	private String filename;
	private Properties properties;

	public PropertyManager(String filename) {
		this.filename = filename;
		this.properties = new Properties();
		
		readPropertyFiles();
	}

	public Properties readPropertyFiles() {
		Properties properties = new Properties();
		try (FileInputStream fileInput = new FileInputStream(new File(filename))) {
			properties.load(fileInput);
		} catch (FileNotFoundException e) {
			LOGGER.error(e.getMessage());
		} catch (IOException e) {
			LOGGER.error(e.getMessage());
		}
		return properties;
	}

	public Integer getPropertyValue(String prop, int defaultValue) {
		Integer value = defaultValue;
		try {
			value = Integer.parseInt(properties.getProperty(prop));

		} catch (NumberFormatException ne) {
			LOGGER.error("Couldn't read integer...using default instead");
		}
		return value;
	}
}
